/*!
 * jKMLMap is a flexible, easy-to-use Javascript library for generating Google Maps from KML files.
 * For features, instructions, licensing details, and a demo, please visit the project homepage.
 *
 * Homepage:  http://www.justin-klein.com/projects/projectjkmlmap
 * License:   http://creativecommons.org/licenses/by-sa/2.5 (for personal use)
 * Version:   1.1.3
 * Copyright: (c) 2010-2013 Justin Klein
 *
 *
 * Change Log:
 *
 * 1.1.3 - 01/03/2013
 * -Centering the map based on the 1st placemark was not working properly
 * -Fix an INVALID_STATE_ERR exception on Webkit browsers
 * -Fix a bug where the first point on polylines was being omitted
 * -Minor change for my own use
 *
 * 1.1.2 - 09/26/2012
 * -Fix XMLHttpRequest error detection for Opera
 * -Fix bug when setting the view from a path (was still using old APIv2 call)
 * -Allow any whitespace as vertex delimiters for paths (required for kmls created via MyMaps on maps.google.com)
 * -Default to Hybrid map type
 * -Only the first-level folders are expanded now
 *
 * 1.1.1 - 08/31/2011
 * -Fix setting the proper zoom
 *
 * 1.1.0 - 08/26/2011
 * -Updated to GMaps API v3.
 *
 * 1.0.1 - 03/02/2010
 * -Fixed a bug setting CSS classes for markers with links when all markers used the same icon
 * -Changed some poorly named CSS classes
 * -Abort when AJAX returns any status other than 200 (not just 404)
 * -Handle markers that contain no coordinates
 * -Add new CSS class for EMPTY folders, so they can be styled differently
 * -Fixed the positioning of the "Created by jKMLMap" text
 * -Add demo HTML to distribute with this file
 *
 * 1.0.0 - 02/28/2010
 * -First Release
 */
function jKMLMap(u){var J=function(L){return(typeof(L)!="undefined")};if(!J(u)){var u={}}var w=J(u.mapDiv)?u.mapDiv:"jKMLMap";var h=J(u.menuDiv)?document.getElementById(u.menuDiv):null;var y=J(u.mkrBasic)?u.mkrBasic:null;var b=J(u.mkrLinks)?u.mkrLinks:null;var e=J(u.mkrSpecial)?u.mkrSpecial:null;var q=J(u.mkrSpecialRegex)?u.mkrSpecialRegex:/Current Location/;var a=J(u.isJustin);w=document.getElementById(w);if(w==null){alert("jKMLMap Error: The mapdiv you specified could not be found.");return}var d=this;var t=null;var G=null;var o=null;var I=null;var k={FOLDER:1,POINT:2,POLYLINE:3};var n=0;var H=0;var g=false;var v=null;var f=false;var p=null;var s=null;var x=null;var E=document.createElement("div");E.setAttribute("id","jkml_map_inner");E.setAttribute("style","width:inherit;height:inherit;");if(document.all){E.style.setAttribute("cssText","width:100%;height:100%;")}w.appendChild(E);var A=new google.maps.LatLng(9.5,-164);var c={center:A,zoom:2,mapTypeId:google.maps.MapTypeId.HYBRID};this.map=new google.maps.Map(E,c);var i=document.createElement("div");i.setAttribute("style","text-align:right;width:100%;");i.innerHTML='<small>Created by <a href="http://www.justin-klein.com/projects/projectjkmlmap">jKMLMap</a></small>';w.appendChild(i);if(J(u.debug)){google.maps.event.addListener(d.map,"bounds_changed",function(){console.log("Map At "+d.map.getCenter()+", Zoom "+d.map.getZoom())})}this.RegisterCallback=function(L,M){if(L=="onComplete"){p=M}else{if(L=="onProgress"){s=M}else{if(L=="onStart"){x=M}else{alert("jKMLMap Error: RegisterCallback does not know about callback '"+L+"'.")}}}};this.LoadMap=function(M){if(I!=null){for(var L=0;L<I.length;L++){if(I[L].type==k.POINT||I[L].type==k.POLYLINE){I[L].setMap(null)}}}g=false;I=[];if(x!=null){x()}B("<strong>Status:</strong> Requesting KML Data...");C(M)};var C=function(L){if(window.ActiveXObject){var N=new ActiveXObject("Microsoft.XMLHTTP");var M=99999999;N.onreadystatechange=function(){if(N.readyState==4){M=N.getResponseHeader("Content-Length")}};N.open("HEAD",L,true);N.send(null);var O=new ActiveXObject("MSXML2.DOMDocument");O.async=true;O.ondataavailable=function(){B("<strong>Status:</strong> Receiving KML Data...",(parseInt(O.text.length/M*100)))};O.onreadystatechange=function(){if(O.readyState==2){B("<strong>Status:</strong> Waiting for KML Data...")}else{if(O.readyState==4){if(O.text.length==0){alert("jKMLMap Error: The KML file you requested could not be downloaded.");B("<strong>Status:</strong> KML Download Error.");return}F(O)}}};O.load(L)}else{if(document.implementation&&document.implementation.createDocument){var O=new XMLHttpRequest();O.onreadystatechange=function(){if(O.readyState==4&&O.status!=200&&O.status!=0){alert("jKMLMap Error: The KML file you requested could not be downloaded (Status: "+O.status+").");B("<strong>Status:</strong> KML Download Error.");O.abort();return}if(O.readyState==2){B("<strong>Status:</strong> Waiting for KML Data...")}else{if(O.readyState==3){var P=0;if(O.responseText){P=parseInt((O.responseText.length+1e-8)/O.getResponseHeader("Content-Length")*100)}else{if(O.responseStream){P=parseInt((O.responseStream.length+1e-8)/O.getResponseHeader("Content-Length")*100)}}B("<strong>Status:</strong> Receiving KML Data...",P)}else{if(O.readyState==4){F((new DOMParser()).parseFromString(O.responseText,"text/xml"))}}}};O.open("GET",L,true);O.send(null)}else{B("<strong>Status:</strong> This script is not supported by your browser!")}}};var F=function(L){t=L;B("<strong>Status:</strong> Parsing KML Data...");setTimeout(r,1)};var r=function(){var L=new Array();z(t.getElementsByTagName("Document")[0],L);delete L;B("<strong>Status:</strong> Adding Markers...");setTimeout(l,1)};var l=function(){for(var L=0;L<I.length;L++){if(I[L].type==k.POINT||I[L].type==k.POLYLINE){I[L].setMap(d.map)}}if(h==null){B("<strong>Status:</strong> Finishing Up...");setTimeout(K,1);return}var M=document.createElement("form");M.setAttribute("name","menuform");G=new Array(M);o=new Array();n=0;H=-1;B("<strong>Status:</strong> Building Menu...");setTimeout(m,1)};var m=function(){var P=(o.length==0);var L=I[n];var N=G[G.length-1];var O=null;if(L.type==k.FOLDER){var R=L.size==0;O=document.createElement("a");O.setAttribute("href","javascript:void(0)");if(R){O.setAttribute("class","kmlFolderEmpty")}else{O.setAttribute("class","kmlFolderBtn")}if(document.all){if(R){O.setAttribute("className","kmlFolderEmpty")}else{O.setAttribute("className","kmlFolderBtn")}}if(!R){O.onclick=(function(T,S){return function(){T.TogDiv("Fldr"+S)}})(d,n)}N.appendChild(O);O=document.createElement("input");O.setAttribute("type","checkbox");O.setAttribute("name","list");O.setAttribute("id","list");O.setAttribute("value",n);O.setAttribute("checked","true");if(document.all){O.setAttribute("defaultChecked","true")}O.onclick=(function(T,S){return function(){T.TogMrk(S,document.getElementsByName("list"),this.checked,true)}})(d,n);N.appendChild(O);O=document.createElement("a");O.setAttribute("title",L.description);O.innerHTML="<strong>"+L.name+"</strong>";N.appendChild(O);N.appendChild(document.createElement("br"));O=document.createElement("div");O.setAttribute("id","Fldr"+n);O.setAttribute("class","fldr");if(document.all){O.setAttribute("className","fldr")}if(document.all){O.style.setAttribute("cssText",(P?"":"display:none;"))}else{O.setAttribute("style",(P?"":"display:none;"))}N.appendChild(O);G.push(O);o.push(L.size+1)}if(L.type==k.POINT||L.type==k.POLYLINE){O=document.createElement("input");O.setAttribute("class","mrkr");if(document.all){O.setAttribute("className","mrkr")}O.setAttribute("type","checkbox");O.setAttribute("name","list");O.setAttribute("id","list");O.setAttribute("value",n);O.setAttribute("checked","true");if(document.all){O.setAttribute("defaultChecked","true")}O.onclick=(function(T,S){return function(){T.TogMrk(S,document.getElementsByName("list"),this.checked,true)}})(d,n);N.appendChild(O);O=document.createElement("a");if(L.type==k.POINT){O.setAttribute("class",(L.hasLnk==true?"haslnk":"nolnk"));if(document.all){O.setAttribute("className",(L.getIcon()==b?"haslnk":"nolnk"))}O.setAttribute("href","javascript:void(0);");O.onclick=(function(S,T){return function(){S[T].onClick()}})(I,n)}var Q=L.description.replace(/<a href=[^>]+>(.+?)<\/a>/i,"$1").replace(/<br \/>.*/,"...");O.setAttribute("title",Q);if(a){O.innerHTML=L.name.replace(/....\/..\/.. - /,"")}else{O.innerHTML=L.name}N.appendChild(O);N.appendChild(document.createElement("br"))}if(o.length>0){for(var M=0;M<o.length;M++){o[M]--}while(o[o.length-1]==0){o.pop();G.pop()}}n++;if(n<I.length){m()}else{B("<strong>Status:</strong> Finishing Up...");setTimeout(K,1)}};var K=function(){if(h!=null&&G.length!=1){alert("jKMLMap Error - I screwed up the elmntStack! Please report this as a bug.")}if(h!=null){var M=h.cloneNode(false);h.parentNode.replaceChild(M,h);h=M;h.appendChild(G[0]);o=null;G=null}if(!g){for(var L=0;L<I.length;L++){if(I[L].type==k.POINT){d.map.setCenter(I[L].position);break}if(I[L].type==k.POLYLINE){var O=I[L].getPath();var N=O.getAt(O.getLength()-1);d.map.setCenter(N);break}}}if(p!=null){p()}};var z=function(P,O){if(typeof(P)=="undefined"){alert("jKMLMap Error: The KML file could not be parsed.  Please be sure it's a correctly formatted KML file, and that it's not empty (has at least one marker or path).");return}for(var N=0;N<P.childNodes.length;N++){if(P.childNodes[N].nodeType!=1){continue}else{if(P.childNodes[N].nodeName=="Placemark"){var L=j(P.childNodes[N]);if(L){I.push(L)}}}if(P.childNodes[N].nodeName=="Folder"){if(I.length==0){D(P.childNodes[N])}O.push(I.length);var L=j(P.childNodes[N]);if(L){I.push(L)}z(P.childNodes[N],O);var M=O.pop();I[M].size=I.length-M-1}if(P.childNodes[N].nodeName=="Document"){z(P.childNodes[N],O)}}};var j=function(P){var N=0;var M=0;var U=0;var Q=0;var S=0;if(P.nodeName=="Folder"){Q=k.FOLDER}else{if(P.nodeName=="Placemark"&&P.getElementsByTagName("Point").length>0){Q=k.POINT}else{if(P.nodeName=="Placemark"&&P.getElementsByTagName("LineString").length>0){Q=k.POLYLINE}else{return null}}}for(var O=0;O<P.childNodes.length;O++){switch(P.childNodes[O].nodeName){case"name":M=P.childNodes[O].childNodes[0].nodeValue;break;case"description":if(a){U=P.childNodes[O].childNodes[0].nodeValue.replace(/<br \/>Marker: <marker>(.+?)<\/marker>/gi,"").replace(/Marker: <marker>(.+?)<\/marker>/gi,"")}else{U=P.childNodes[O].childNodes[0].nodeValue}break}}if(Q==k.POINT){S=P.getElementsByTagName("Point")[0].getElementsByTagName("coordinates")[0].childNodes[0].nodeValue.split(",");S=new google.maps.LatLng(parseFloat(S[1]),parseFloat(S[0]))}else{if(Q==k.POLYLINE){S=new Array();var V=P.getElementsByTagName("LineString")[0].getElementsByTagName("coordinates")[0].childNodes[0].nodeValue.split(/\s+/);for(var O=0;O<V.length;O++){var T=V[O].split(",");if(T.length!=3){continue}S.push(new google.maps.LatLng(parseFloat(T[1]),parseFloat(T[0])))}}}if(Q==k.FOLDER){N=new Object();N.name=M;N.type=Q;N.description=U?U:"No Description"}else{if(Q==k.POINT){var R;var L=false;if(U&&U.search(q)!=-1){R=e}if(a&&!f){R=e;f=true}else{if(U&&U.search(/http:\/\//)!=-1){R=b;L=true}else{R=y}}N=new google.maps.Marker({position:S,title:M,icon:R});if(R==e){N.zIndex=999}N.name=M;N.type=Q;N.hasLnk=L;N.description=U?U:"No Description";N.onClick=function(){var W=new google.maps.InfoWindow({content:"<h3>"+this.name+"</h3>"+this.description});if(d.openedInfoWindow!=null){d.openedInfoWindow.close()}W.open(this.map,this);d.openedInfoWindow=W};google.maps.event.addListener(N,"click",N.onClick)}else{if(Q==k.POLYLINE){N=new google.maps.Polyline({path:S,strokeColor:"#FF0000",strokeWeight:3,strokeOpacity:0.9});N.name=M;N.type=Q;N.description=U?U:"No Description"}}}return N};var D=function(Q){for(var N=0;N<Q.childNodes.length;N++){if(Q.childNodes[N].nodeName=="LookAt"){var P=Q.childNodes[N].getElementsByTagName("latitude")[0].childNodes[0].nodeValue;var M=Q.childNodes[N].getElementsByTagName("longitude")[0].childNodes[0].nodeValue;var L=Q.childNodes[N].getElementsByTagName("range")[0].childNodes[0].nodeValue;var O=Math.round(26-(Math.log(L)/Math.log(2)));if(O<0){O=0}if(O>21){O=21}d.map.setCenter(new google.maps.LatLng(P,M));d.map.setZoom(O);g=true}}};var B=function(M,L){if(s!=null){s(M,typeof(L)=="undefined"?0:L)}};this.TogMrk=function(M,O,P,L){O[M].checked=P;if(I[M].type==k.FOLDER){if(L){for(var N=0;N<I[M].size;N++){this.TogMrk(N+M+1,O,P,false)}}}else{if(P){I[M].setMap(this.map)}else{I[M].setMap(null)}}};this.TogDiv=function(M){var L=0;if(document.getElementById){L=document.getElementById(M).style}else{if(document.all){L=document.all[M].style}else{if(document.layers){L=document.layers[M].style}else{return}}}L.display=(L.display=="none"?"block":"none")}}function CreateGIcon(f,c,a,b){var e=a;if(b){e=a/2}var d=new google.maps.MarkerImage();d.url=f;d.scaledSize=new google.maps.Size(c,a);d.anchor=new google.maps.Point(c/2,e);return d};